import  java.awt.*;
/**
 * A six sided Die.
 * 
 * @author Chris Thiel, OFMCap
 * @version 21 Aug 2010
 */
public class Die
{
    // instance variables - 
    private int size;
    private int x; //top left corner
    private int y;
    private int pips;

    private Color color;

    /**
     * Constructor for objects of class Die
     */
    public Die(int x, int y, int size)
    {

        this.size=size;
        this.x=x;
        this.y=y;
        this.pips=(int)(Math.random()*6.0)+1;
        this.color=Color.WHITE;
    }
    public int getValue(){
    		return pips;
    }
    public void setColor(Color c)
    {
        this.color=c;
    }

    public void draw(Graphics g)
    {
        g.setColor(color);
        g.fillRect(x,y,size,size);
        g.setColor(Color.BLACK);
        g.drawRect(x,y,size,size);

        g.setColor(Color.BLACK);
        int dotSize=size/7;
        if (pips%2==1){
            g.fillOval(x+3*dotSize, y+3*dotSize, dotSize,dotSize);
        }
        if (pips>1){
            g.fillOval(x+dotSize, y+dotSize, dotSize,dotSize);
            g.fillOval(x+5*dotSize, y+5*dotSize, dotSize,dotSize);
        }
        if (pips>3){
            g.fillOval(x+dotSize, y+5*dotSize, dotSize,dotSize);
            g.fillOval(x+5*dotSize, y+dotSize, dotSize,dotSize);
        }
        if (pips==6){
            g.fillOval(x+dotSize, y+3*dotSize, dotSize,dotSize);
            g.fillOval(x+5*dotSize, y+3*dotSize, dotSize,dotSize);
        }
    }
}